/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.TPointer;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.memory.DebuggerMemory;
import jpcsp.memory.IMemoryWriter;

public class MemoryWriter {
    private static int getMaxLength(int address) {
        int length = address >= 0x8000000 && address <= MemoryMap.END_RAM ? MemoryMap.END_RAM - address + 1 : (address >= 0x4000000 && address <= 0x41FFFFF ? 0x41FFFFF - address + 1 : (address >= 65536 && address <= 81919 ? 81919 - address + 1 : 0));
        return length;
    }

    private static IMemoryWriter getFastMemoryWriter(int address, int step) {
        int[] memoryInt = RuntimeContext.getMemoryInt();
        switch (step) {
            case 1: {
                return new MemoryWriterIntArray8(memoryInt, address);
            }
            case 2: {
                return new MemoryWriterIntArray16(memoryInt, address);
            }
            case 4: {
                return new MemoryWriterIntArray32(memoryInt, address);
            }
        }
        return new MemoryWriterGeneric(address, MemoryWriter.getMaxLength(address), step);
    }

    public static IMemoryWriter getMemoryWriter(int address, int length, int step) {
        if (RuntimeContext.hasMemoryInt(address)) {
            return MemoryWriter.getFastMemoryWriter(address, step);
        }
        if (!DebuggerMemory.isInstalled()) {
            Buffer buffer = Emulator.getMemory(address).getBuffer(address, length);
            if (buffer instanceof IntBuffer) {
                IntBuffer intBuffer = (IntBuffer)buffer;
                switch (step) {
                    case 1: {
                        return new MemoryWriterInt8(intBuffer, address);
                    }
                    case 2: {
                        return new MemoryWriterInt16(intBuffer, address);
                    }
                    case 4: {
                        return new MemoryWriterInt32(intBuffer, address);
                    }
                }
            } else if (buffer instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)buffer;
                switch (step) {
                    case 1: {
                        return new MemoryWriterByte8(byteBuffer, address);
                    }
                    case 2: {
                        return new MemoryWriterByte16(byteBuffer, address);
                    }
                    case 4: {
                        return new MemoryWriterByte32(byteBuffer, address);
                    }
                }
            }
        }
        return new MemoryWriterGeneric(address, length, step);
    }

    public static IMemoryWriter getMemoryWriter(int address, int step) {
        if (RuntimeContext.hasMemoryInt(address)) {
            return MemoryWriter.getFastMemoryWriter(address, step);
        }
        return MemoryWriter.getMemoryWriter(address, MemoryWriter.getMaxLength(address), step);
    }

    public static IMemoryWriter getMemoryWriter(Memory mem, int address, int length, int step) {
        if (mem == RuntimeContext.memory) {
            return MemoryWriter.getMemoryWriter(address, length, step);
        }
        return new MemoryWriterGeneric(mem, address, length, step);
    }

    public static IMemoryWriter getMemoryWriter(TPointer address, int length, int step) {
        return MemoryWriter.getMemoryWriter(address.getMemory(), address.getAddress(), length, step);
    }

    private static class MemoryWriterByte32
    implements IMemoryWriter {
        private ByteBuffer buffer;
        private int address;

        public MemoryWriterByte32(ByteBuffer buffer, int address) {
            this.buffer = buffer;
            this.address = address;
        }

        @Override
        public void writeNext(int value) {
            this.buffer.putInt(value);
        }

        @Override
        public void flush() {
        }

        @Override
        public final void skip(int n) {
            if (n > 0) {
                this.buffer.position(this.buffer.position() + (n << 2));
            }
        }

        @Override
        public int getCurrentAddress() {
            return this.address + this.buffer.position();
        }
    }

    private static class MemoryWriterByte16
    implements IMemoryWriter {
        private ByteBuffer buffer;
        private int address;

        public MemoryWriterByte16(ByteBuffer buffer, int address) {
            this.buffer = buffer;
            this.address = address;
        }

        @Override
        public void writeNext(int value) {
            this.buffer.putShort((short)value);
        }

        @Override
        public void flush() {
        }

        @Override
        public final void skip(int n) {
            if (n > 0) {
                this.buffer.position(this.buffer.position() + (n << 1));
            }
        }

        @Override
        public int getCurrentAddress() {
            return this.address + this.buffer.position();
        }
    }

    private static class MemoryWriterByte8
    implements IMemoryWriter {
        private ByteBuffer buffer;
        private int address;

        public MemoryWriterByte8(ByteBuffer buffer, int address) {
            this.buffer = buffer;
            this.address = address;
        }

        @Override
        public void writeNext(int value) {
            this.buffer.put((byte)value);
        }

        @Override
        public void flush() {
        }

        @Override
        public final void skip(int n) {
            if (n > 0) {
                this.buffer.position(this.buffer.position() + n);
            }
        }

        @Override
        public int getCurrentAddress() {
            return this.address + this.buffer.position();
        }
    }

    private static class MemoryWriterInt32
    implements IMemoryWriter {
        private IntBuffer buffer;
        private int address;

        public MemoryWriterInt32(IntBuffer buffer, int address) {
            this.buffer = buffer;
            this.address = address;
        }

        @Override
        public void writeNext(int value) {
            this.buffer.put(value);
        }

        @Override
        public void flush() {
        }

        @Override
        public void skip(int n) {
            if (n > 0) {
                this.buffer.position(this.buffer.position() + n);
            }
        }

        @Override
        public int getCurrentAddress() {
            return this.address + (this.buffer.position() << 2);
        }
    }

    private static class MemoryWriterInt16
    implements IMemoryWriter {
        private int index;
        private int value;
        private IntBuffer buffer;
        private int address;

        public MemoryWriterInt16(IntBuffer buffer, int address) {
            this.buffer = buffer;
            this.address = address & 0xFFFFFFFC;
            this.index = (address & 2) >> 1;
            if (this.index != 0 && buffer.capacity() > 0) {
                this.value = buffer.get(buffer.position()) & 0xFFFF;
            }
        }

        @Override
        public void writeNext(int n) {
            if (this.index == 0) {
                this.value = n & 0xFFFF;
                this.index = 1;
            } else {
                this.buffer.put(n << 16 | this.value);
                this.index = 0;
            }
        }

        @Override
        public void flush() {
            if (this.index != 0) {
                this.buffer.put(this.buffer.get(this.buffer.position()) & 0xFFFF0000 | this.value);
            }
        }

        @Override
        public void skip(int n) {
            if (n > 0) {
                int bufferSkip = 0;
                if (this.index != 0) {
                    this.flush();
                    ++bufferSkip;
                    --n;
                }
                this.buffer.position(this.buffer.position() + (bufferSkip += n / 2));
                this.index = n & 1;
                if (this.index != 0) {
                    this.value = this.buffer.get(this.buffer.position()) & 0xFFFF;
                }
            }
        }

        @Override
        public int getCurrentAddress() {
            return this.address + (this.buffer.position() << 2) + this.index;
        }
    }

    private static class MemoryWriterInt8
    implements IMemoryWriter {
        private int index;
        private int value;
        private IntBuffer buffer;
        private int address;
        private static final int[] mask = new int[]{0, 255, 65535, 0xFFFFFF, -1};

        public MemoryWriterInt8(IntBuffer buffer, int address) {
            this.buffer = buffer;
            this.address = address & 0xFFFFFFFC;
            this.index = address & 3;
            if (this.index > 0 && buffer.capacity() > 0) {
                this.value = buffer.get(buffer.position()) & mask[this.index];
            }
        }

        @Override
        public void writeNext(int n) {
            n &= 0xFF;
            if (this.index == 4) {
                this.buffer.put(this.value);
                this.value = n;
                this.index = 1;
            } else {
                this.value |= n << (this.index << 3);
                ++this.index;
            }
        }

        @Override
        public void flush() {
            if (this.index > 0) {
                this.buffer.put(this.buffer.get(this.buffer.position()) & ~mask[this.index] | this.value);
            }
        }

        @Override
        public void skip(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCurrentAddress() {
            return this.address + (this.buffer.position() << 2) + this.index;
        }
    }

    private static class MemoryWriterIntArray32
    implements IMemoryWriter {
        private int offset;
        private int[] buffer;

        public MemoryWriterIntArray32(int[] buffer, int addr) {
            this.offset = (addr & 0x1FFFFFFF) >> 2;
            this.buffer = buffer;
        }

        @Override
        public void writeNext(int value) {
            this.buffer[this.offset++] = value;
        }

        @Override
        public void flush() {
        }

        @Override
        public void skip(int n) {
            this.offset += n;
        }

        @Override
        public int getCurrentAddress() {
            return this.offset << 2;
        }
    }

    private static class MemoryWriterIntArray16
    implements IMemoryWriter {
        private int index;
        private int offset;
        private int value;
        private int[] buffer;

        public MemoryWriterIntArray16(int[] buffer, int addr) {
            this.buffer = buffer;
            this.offset = (addr & 0x1FFFFFFF) >> 2;
            this.index = addr >> 1 & 1;
            if (this.index != 0) {
                this.value = buffer[this.offset] & 0xFFFF;
            }
        }

        @Override
        public void writeNext(int n) {
            if (this.index == 0) {
                this.value = n & 0xFFFF;
                this.index = 1;
            } else {
                this.buffer[this.offset++] = n << 16 | this.value;
                this.index = 0;
            }
        }

        @Override
        public void flush() {
            if (this.index != 0) {
                this.buffer[this.offset] = this.buffer[this.offset] & 0xFFFF0000 | this.value;
            }
        }

        @Override
        public void skip(int n) {
            if (n > 0) {
                this.flush();
                this.index += n;
                this.offset += this.index >> 1;
                this.index &= 1;
                if (this.index != 0) {
                    this.value = this.buffer[this.offset] & 0xFFFF;
                }
            }
        }

        @Override
        public int getCurrentAddress() {
            return (this.offset << 2) + (this.index << 1);
        }
    }

    private static class MemoryWriterIntArray8
    implements IMemoryWriter {
        private int index;
        private int offset;
        private int value;
        private int[] buffer;
        private static final int[] mask = new int[]{0, 255, 65535, 0xFFFFFF, -1};

        public MemoryWriterIntArray8(int[] buffer, int addr) {
            this.buffer = buffer;
            this.offset = (addr & 0x1FFFFFFF) >> 2;
            this.index = addr & 3;
            this.value = buffer[this.offset] & mask[this.index];
        }

        @Override
        public void writeNext(int n) {
            n &= 0xFF;
            if (this.index == 4) {
                this.buffer[this.offset++] = this.value;
                this.value = n;
                this.index = 1;
            } else {
                this.value |= n << (this.index << 3);
                ++this.index;
            }
        }

        @Override
        public void flush() {
            if (this.index > 0) {
                this.buffer[this.offset] = this.buffer[this.offset] & ~mask[this.index] | this.value;
            }
        }

        @Override
        public final void skip(int n) {
            if (n > 0) {
                this.flush();
                this.index += n;
                this.offset += this.index >> 2;
                this.index &= 3;
                this.value = this.buffer[this.offset] & mask[this.index];
            }
        }

        @Override
        public int getCurrentAddress() {
            return (this.offset << 2) + this.index;
        }
    }

    private static class MemoryWriterGeneric
    implements IMemoryWriter {
        private Memory mem;
        private int address;
        private int length;
        private int step;

        public MemoryWriterGeneric(Memory mem, int address, int length, int step) {
            this.mem = mem;
            this.address = address;
            this.length = length;
            this.step = step;
        }

        public MemoryWriterGeneric(int address, int length, int step) {
            this.address = address;
            this.length = length;
            this.step = step;
            this.mem = Memory.getInstance();
        }

        @Override
        public void writeNext(int value) {
            if (this.length <= 0) {
                return;
            }
            switch (this.step) {
                case 1: {
                    this.mem.write8(this.address, (byte)value);
                    break;
                }
                case 2: {
                    this.mem.write16(this.address, (short)value);
                    break;
                }
                case 4: {
                    this.mem.write32(this.address, value);
                }
            }
            this.address += this.step;
            this.length -= this.step;
        }

        @Override
        public void flush() {
        }

        @Override
        public void skip(int n) {
            this.address += n * this.step;
            this.length -= n * this.step;
        }

        @Override
        public int getCurrentAddress() {
            return this.address;
        }
    }
}

